/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.sinytra.fabric.networking_api.client.NeoClientConfigurationNetworking;

public final class ClientConfigurationNetworking {
    public static <T extends CustomPacketPayload> boolean registerGlobalReceiver(CustomPacketPayload.Type<T> type, ConfigurationPayloadHandler<T> handler) {
        return NeoClientConfigurationNetworking.registerGlobalReceiver(type, handler);
    }

    @Nullable
    public static ConfigurationPayloadHandler<?> unregisterGlobalReceiver(CustomPacketPayload.Type<?> id) {
        return NeoClientConfigurationNetworking.unregisterGlobalReceiver(id.id());
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return NeoClientConfigurationNetworking.getGlobalReceivers();
    }

    public static <T extends CustomPacketPayload> boolean registerReceiver(CustomPacketPayload.Type<T> id, ConfigurationPayloadHandler<T> handler) {
        return NeoClientConfigurationNetworking.registerReceiver(id, handler);
    }

    @Nullable
    public static ConfigurationPayloadHandler<?> unregisterReceiver(ResourceLocation id) {
        return NeoClientConfigurationNetworking.unregisterReceiver(id);
    }

    public static Set<ResourceLocation> getReceived() throws IllegalStateException {
        return NeoClientConfigurationNetworking.getReceived();
    }

    public static Set<ResourceLocation> getSendable() throws IllegalStateException {
        return NeoClientConfigurationNetworking.getSendable();
    }

    public static boolean canSend(ResourceLocation channelName) throws IllegalArgumentException {
        if (Minecraft.getInstance().getConnection() != null && Minecraft.getInstance().getConnection().protocol() == ConnectionProtocol.CONFIGURATION) {
            return NeoClientConfigurationNetworking.canSend(channelName);
        }
        return false;
    }

    public static boolean canSend(CustomPacketPayload.Type<?> type) {
        return ClientConfigurationNetworking.canSend(type.id());
    }

    public static PacketSender getSender() throws IllegalStateException {
        return NeoClientConfigurationNetworking.getSender();
    }

    public static void send(CustomPacketPayload payload) {
        NeoClientConfigurationNetworking.send(payload);
    }

    private ClientConfigurationNetworking() {
    }

    @FunctionalInterface
    public static interface ConfigurationPayloadHandler<T extends CustomPacketPayload> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public Minecraft client();

        public ClientConfigurationPacketListenerImpl networkHandler();

        public PacketSender responseSender();
    }
}

